/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWHasParameterDefs;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWParameterDefinition
extends VWMLABase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7536L;
    protected String name = null;
    protected String value = null;
    protected String description = null;
    protected int mode;
    protected boolean isArray = false;
    protected int dataType = -1;
    protected IVWHasParameterDefs myContainer;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-08-16 18:21:51 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/9 $";
    }

    protected VWParameterDefinition(IVWHasParameterDefs theContainer, String theName, int theMode, String theValue, int theType, boolean theIsArray) throws VWException {
        if (theContainer == null) {
            throw new VWException("vw.api.VWParameterDefinitionInvalidContainer", "theContainer is invalid, (null), must be a reference to an object which implements IVWHasParameters.");
        }
        this.myContainer = theContainer;
        this.setDataType(theType);
        this.setValue(theValue);
        this.setIsArray(theIsArray);
        this.setMode(theMode);
        this.setName(theName);
    }

    protected VWParameterDefinition(VWCompoundStepDefinition theContainer, String theName, int theMode, String theValue, int theType, boolean theIsArray) throws VWException {
        if (theContainer == null) {
            throw new VWException("vw.api.VWParameterDefinitionInvalidContainer", "theContainer is invalid, (null), must be a reference to an object which implements IVWHasParameters.");
        }
        this.myContainer = theContainer;
        this.setDataType(theType);
        this.setValue(theValue);
        this.setIsArray(theIsArray);
        this.setMode(theMode);
        this.setName(theName);
    }

    protected VWParameterDefinition(String theName, int theMode, int theType, boolean theIsArray, String theDescription) throws VWException {
        this.name = theName;
        this.mode = theMode;
        this.value = null;
        this.dataType = theType;
        this.isArray = theIsArray;
        this.description = theDescription;
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWParameterDefinitionBadName", "Parameter name cannot be null");
        }
        VWParameterDefinition existingParameter = null;
        try {
            existingParameter = this.myContainer.getParameterDefinition(theName);
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (existingParameter != null) {
            throw new VWException("vw.api.VWParameterDefinitionParameterAlreadyExists", "theName is invalid, (a parameter with name \"{0}\" already exists in this step definition).", theName);
        }
        if (!this.isValidParameterName(theName)) {
            throw new VWException("vw.api.VWParameterDefinitionIllFormedName", "Syntax error in parameter name \"{0}\".", theName);
        }
        this.name = theName;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int theMode) throws VWException {
        if (!VWModeType.isValid(theMode)) {
            throw new VWException("vw.api.VWParameterDefinitionInvalidModeType", "theModeType is not a valid mode type");
        }
        this.mode = theMode;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int theDataType) throws VWException {
        if (!VWFieldType.isValid(theDataType)) {
            throw new VWException("vw.api.VWParameterDefinitionInvalidFieldType", "theDataType is invalid.");
        }
        this.dataType = theDataType;
    }

    public boolean getIsArray() {
        return this.isArray;
    }

    public void setIsArray(boolean theIsArray) {
        this.isArray = theIsArray;
    }

    public String getName() {
        return this.translateStr(this.name);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String theValue) throws VWException {
        if (this.myContainer instanceof VWStepDefinition && theValue == null) {
            throw new VWException("vw.api.VWParameterDefinitionBadValue", "Parameter value cannot be null");
        }
        this.value = theValue != null ? theValue.trim() : null;
    }

    public String getDescription() {
        return this.translateStr(this.description);
    }

    public void setDescription(String theDescription) {
        this.description = theDescription;
    }

    public String toString() {
        return this.getName();
    }

    protected VWMapNode getStep() throws VWException {
        if (this.myContainer instanceof VWMapNode) {
            return (VWMapNode)((Object)this.myContainer);
        }
        return null;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWOperationDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        theBuffer.append(INDENT_0 + "<" + "Parameter" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.name) + "\"\n");
        if (this.description != null) {
            theBuffer.append(INDENT_1 + "Description" + "=\"" + VWXMLHandler.toXMLString(this.description) + "\"\n");
        }
        if (this.value != null) {
            theBuffer.append(INDENT_1 + "ValueExpr" + "=\"" + VWXMLHandler.toXMLString(this.value) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "Type" + "=\"" + VWFieldType.typeToString(this.dataType) + "\"\n");
        theBuffer.append(INDENT_1 + "IsArray" + "=\"" + this.isArray + "\"\n");
        theBuffer.append(INDENT_1 + "Mode" + "=\"" + VWModeType.typeToString(this.mode) + "\"");
        theBuffer.append("/>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWOperationDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<DataMapping Formal=\"" + VWXMLHandler.toXMLString(this.name) + "\" Direction=\"" + VWModeType.typeToString(this.mode).toUpperCase() + "\">\n");
        theBuffer.append(indentB + "<Actual>" + VWXMLHandler.toXMLString(this.value == null ? this.name : this.value) + "</Actual>\n");
        theBuffer.append(indentB + "<fn:Parameter Type=\"" + VWFieldType.typeToString(this.dataType) + "\" IsArray=\"" + this.isArray + "\"");
        if (this.description != null) {
            theBuffer.append("\n" + indentC + "Description=\"" + VWXMLHandler.toXMLString(this.description) + "\"");
        }
        theBuffer.append("/>\n");
        theBuffer.append(indentA + "</DataMapping>\n");
    }

    public void validate(Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(null, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        if (this.getStep() == null) {
            throw new VWException("vw.api.VWParameterDefinitionCantValidateNotInAStep", "This parameter definition is not contained in a step and therefore cannot be validated.");
        }
        if (this.value != null && this.value.compareTo("") != 0) {
            VWCompiledExpr compRes = null;
            String[] theErrorStrings = null;
            VWWorkflowSignature myWflSignature = this.getStep().getMap().getWorkflow().getWorkflowSignature(validationContext);
            VWWorkflowSignature myBaseWflSignature = this.getStep().getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            if (this.mode == 3 || this.mode == 2) {
                compRes = new VWCompiledRefExpr();
                theErrorStrings = VWExpr.compileVWExpr(":=" + this.value, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            } else {
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.value, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            }
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int i = 0; i < errorCount; ++i) {
                    VWString theMessage2 = new VWString("vw.api.VWParameterDefinitionSyntaxError", "Parameter {0}, {1}", this.name, theErrorStrings[i]);
                    VWValidationError theError2 = new VWValidationError(3, 1, this.getStep().getName(), this.name, theMessage2.toString(), this.getStep().getMap().getName(), this.getStep().getStepId());
                    validationContext.addValidationError(theError2);
                }
            } else {
                VWValidationError theError3;
                VWString theMessage3;
                if (this.isArray != compRes.getResultIsArray()) {
                    theMessage3 = new VWString("vw.api.VWParameterDefinitionArrayTypeMismatch", "Parameter {0}, whose value is ({1}), Array v. non-array mismatch", this.name, this.value);
                    theError3 = new VWValidationError(3, 1, this.getStep().getName(), this.name, theMessage3.toString(), this.getStep().getMap().getName(), this.getStep().getStepId());
                    validationContext.addValidationError(theError3);
                }
                if (!VWFieldType.isCompatibleType(this.dataType, compRes.getResultType())) {
                    theMessage3 = new VWString("vw.api.VWParameterDefinitionIncompatibleExpressionType", "Parameter definition value type found {0}, expected {1}", VWFieldType.typeToString(compRes.getResultType()), VWFieldType.typeToString(this.dataType));
                    theError3 = new VWValidationError(3, 1, this.getStep().getName(), this.name, theMessage3.toString(), this.getStep().getMap().getName(), this.getStep().getStepId());
                    validationContext.addValidationError(theError3);
                }
            }
        } else {
            theMessage = new VWString("vw.api.VWParameterDefinitionParamValueNullOrEmpty", "Parameter {0} value is null or empty", this.name);
            theError = new VWValidationError(3, 1, this.getStep().getName(), this.name, theMessage.toString(), this.getStep().getMap().getName(), this.getStep().getStepId());
            validationContext.addValidationError(theError);
        }
        if (!this.isValidParameterName(this.name)) {
            theMessage = new VWString("vw.api.VWParameterDefinitionInvalidParamName", "Parameter name {0} is invalid", this.name);
            theError = new VWValidationError(3, 1, this.getStep().getName(), this.name, theMessage.toString(), this.getStep().getMap().getName(), this.getStep().getStepId());
            validationContext.addValidationError(theError);
        }
    }

    public Object clone() {
        try {
            VWParameterDefinition paramDef = (VWParameterDefinition)super.clone();
            return paramDef;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    protected void setMyContainer(IVWHasParameterDefs theContainer) throws VWException {
        this.myContainer = theContainer;
    }

    protected VWSession getSession() throws VWException {
        VWSession session = null;
        try {
            if (this.myContainer != null) {
                session = this.myContainer.getSession();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return session;
    }

    protected boolean isValidParameterName(String theName) throws VWException {
        if (this.getStep() != null && theName.equals("F_Trackers") && this.getValue().equals("F_Trackers") && this.getDataType() == 64 && this.getIsArray() && this.getStep().getStepId() == 0 && this.getStep().getMap().getName().equals("Workflow")) {
            return true;
        }
        if (this.getStep() != null && (theName.equals("F_CaseFolder") && this.getValue().equals("F_CaseFolder") || theName.equals("F_CaseTask") && this.getValue().equals("F_CaseTask")) && this.getDataType() == 512 && !this.getIsArray()) {
            return true;
        }
        return VWFieldType.isValidParamName(theName);
    }
}

